unit DataModule_DMCOMP;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, DMAssists, BDE;

type
  TDMCOMP = class(TDataModule)
    COMPSource: TDataSource;
    COMP: TTable;
    COMPCompNo: TAutoIncField;
    COMPDescription: TStringField;
    COMPDetails: TMemoField;
    COMPComponent: TBlobField;
    AUTHORSource: TDataSource;
    AUTHOR: TTable;
    DMAssists: TDMAssists;
    COMPAuNo: TIntegerField;
    COMPAuthor: TStringField;
    AUTHORAuNo: TAutoIncField;
    AUTHORAuthor: TStringField;
    AUTHOREmail: TStringField;
    AUTHORWWW: TStringField;
    AUTHORMemo: TMemoField;
    COMPRecordDate: TDateField;
    COMPFileName: TStringField;
    S1: TSession;
    COMPWareType: TStringField;
    COMPPrice: TCurrencyField;
    QCOMP: TQuery;
    QCOMPCompNo: TIntegerField;
    QCOMPAuNo: TIntegerField;
    QCOMPAuthor: TStringField;
    QCOMPDescription: TStringField;
    QCOMPDetails: TMemoField;
    QCOMPRecordDate: TDateField;
    QCOMPSource: TDataSource;
    procedure COMPSourceDataChange(Sender: TObject; Field: TField);
    procedure COMPAfterPost(DataSet: TDataSet);
    procedure DMCOMPCreate(Sender: TObject);
    procedure COMPSourceStateChange(Sender: TObject);
    procedure COMPAfterDelete(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure RefreshQComp;
  end;

var
  DMCOMP: TDMCOMP;

implementation

uses Form_Splash, Form_Component;

{$R *.DFM}

procedure TDMCOMP.COMPSourceDataChange(Sender: TObject; Field: TField);
begin
     If Assigned(FormComponent) then
     FormComponent.FileListBox1.FileName := CompFileName.AsString;
end;

procedure TDMCOMP.COMPAfterPost(DataSet: TDataSet);
begin
     RefreshQComp;
end;

procedure TDMCOMP.DMCOMPCreate(Sender: TObject);
begin
     S1.Active := True;
end;

procedure TDMCOMP.COMPSourceStateChange(Sender: TObject);
var
StatusText : String;
begin
     Case TDataSource(Sender).State of
     dsInsert :
     begin
          StatusText := 'Insert';
     end;
     dsBrowse :
     begin
          StatusText := 'Browse';
     end;
     dsEdit :
     begin
          StatusText := 'Edit';
     end;
     end;

     If Assigned(FormComponent) then
     FormComponent.StatusBar.SimpleText := TDataSource(Sender).DataSet.Name +
     ' Table Status : '+StatusText;
end;

procedure TDMCOMP.COMPAfterDelete(DataSet: TDataSet);
begin
     RefreshQComp;
end;


procedure TDMComp.RefreshQComp;
var
ActiveStatus : Boolean;
begin
     ActiveStatus := QComp.Active;
     QComp.Close;
     QComp.Active := ActiveStatus;
end;


end.
